<?php 
require_once 'includes/auth.php';
checkRole(['superadmin', 'developer']); 

// Update PIN jika ada request POST
if(isset($_POST['update_pin'])) {
    $newPin = $_POST['pin_value'];
    
    // Validasi PIN (harus 4 digit angka)
    if(!preg_match('/^[0-9]{4}$/', $newPin)) {
        $_SESSION['error'] = "PIN harus 4 digit angka!";
    } else {
        try {
            // Enkripsi PIN sebelum disimpan
            $encryptedPin = encryptPin($newPin);
            
            $stmt = $pdo->prepare("UPDATE pin_settings SET pin_value = ?, updated_by = ?, updated_at = NOW() WHERE id = 1");
            $stmt->execute([$encryptedPin, $_SESSION['user_id']]);
            $_SESSION['success'] = "PIN berhasil diupdate!";
        } catch(PDOException $e) {
            error_log("Error updating PIN: " . $e->getMessage());
            $_SESSION['error'] = "Gagal mengupdate PIN!";
        }
    }
    header("Location: token_settings.php");
    exit();
}

// Ambil PIN saat ini
try {
    $stmt = $pdo->prepare("SELECT pin_value FROM pin_settings WHERE id = 1");
    $stmt->execute();
    $encryptedPin = $stmt->fetchColumn();
    
    // Dekripsi PIN untuk ditampilkan
    if ($encryptedPin) {
        $currentPin = decryptPin($encryptedPin);
    } else {
        $currentPin = ''; // Jika belum ada data
    }
} catch(PDOException $e) {
    error_log("Error fetching PIN: " . $e->getMessage());
    $currentPin = ''; // Set default jika terjadi error
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Token Settings</h1>
        
        <?php if(isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['success'];
                unset($_SESSION['success']);
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['error'];
                unset($_SESSION['error']);
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Update Token</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Token Value (4 digits)</label>
                                <input type="text" class="form-control" name="pin_value" 
                                       value="<?php echo htmlspecialchars($currentPin); ?>" 
                                       maxlength="4" pattern="[0-9]{4}" required>
                            </div>
                            <button type="submit" name="update_pin" class="btn btn-primary">
                                Update Token
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 