// Fungsi sorting untuk tabel
var sortDirection = 1;

function sortTable(column) {
    const tbody = document.getElementById('tableBody');
    const rows = Array.from(tbody.getElementsByTagName('tr'));
    
    sortDirection *= -1;
    
    const th = document.querySelector(`.table2 th[onclick="sortTable('${column}')"]`);
    const icon = th.querySelector('i');
    icon.className = sortDirection === 1 ? 'fas fa-sort-up ms-1' : 'fas fa-sort-down ms-1';
    
    rows.sort((a, b) => {
        let aValue, bValue;
        
        if (column === 'action') {
            aValue = a.querySelector(`td[data-action]`).getAttribute('data-action');
            bValue = b.querySelector(`td[data-action]`).getAttribute('data-action');
        } else if (column === 'nd') {
            aValue = a.querySelector(`td[data-nd]`).getAttribute('data-nd');
            bValue = b.querySelector(`td[data-nd]`).getAttribute('data-nd');
        }
        
        return aValue.localeCompare(bValue) * sortDirection;
    });
    
    rows.forEach(row => tbody.appendChild(row));
    
    rows.forEach((row, index) => {
        row.querySelector('td:first-child').textContent = index + 1;
    });
} 