document.addEventListener('DOMContentLoaded', function() {
    // Fungsi untuk menghapus dot status
    function removeDotStatus(supervisorId) {
        const dotElement = document.querySelector(`.dot-status[data-supervisor-id="${supervisorId}"]`);
        if (dotElement) {
            dotElement.remove();
        }
    }

    // Event listener untuk tombol download
    const downloadButtons = document.querySelectorAll('.download-btn');
    downloadButtons.forEach(button => {
        button.addEventListener('click', function() {
            const supervisorId = this.getAttribute('data-supervisor-id');
            removeDotStatus(supervisorId);
        });
    });
}); 